@setlocal enabledelayedexpansion
REM Set the code page to UTF-8
chcp 65001

REM Set input parameters
set VSIX_FILE=%1
echo First input parameter: %1, which is the path of .vsix/.carts file, for example: ".\vscode-codebot-103.12.0-1734691773.vsix"

set TEMP_DIR=.\vsix_temp
set OUTPUT_DIR=.\new_extension

set ZIP_TOOL=%2
echo Second input parameter: %2, which is the path of zip tool, for example: "C:\Program Files\7-Zip\7z.exe"

set BRAND_NAME=%3
echo Third input parameter: %3, which is the target brand name, for example: HaiCoder

REM Check if files exist
if not exist %VSIX_FILE% (
    echo VSIX file not found: %VSIX_FILE%
    goto :eof
)

if not exist %ZIP_TOOL% (
    echo Zip tool not found: %ZIP_TOOL%
    goto :eof
)

rem check file extension
set "ext=%VSIX_FILE:~-5%"
if "%ext%"==".vsix" (
    echo file %VSIX_FILE% is end with .vsix
    set EXTENSION_PATH=extension
) else if "%ext%"=="carts" (
    echo file %VSIX_FILE% is end with .carts
    set "EXTENSION_PATH="
) else (
    echo file %VSIX_FILE% invalid because file is not end with .vsix or carts.
    goto :eof
)


REM Clean and create temporary directory
if exist "%TEMP_DIR%" (rmdir /s /q %TEMP_DIR%)
mkdir %TEMP_DIR%

REM Extract VSIX file to temporary directory
%ZIP_TOOL% x "%VSIX_FILE%" -o%TEMP_DIR%

REM 4
set PRODUCT_JSON=%TEMP_DIR%\%EXTENSION_PATH%\product.json
echo %PRODUCT_JSON%
if exist "%PRODUCT_JSON%" (
    REM 5
    powershell -Command "(Get-Content %PRODUCT_JSON% -Encoding UTF8) -replace '\"customEnglishBrandName\": \"\"', ('\"customEnglishBrandName\": \"%BRAND_NAME%\"') | Set-Content %PRODUCT_JSON% -Encoding UTF8"
	powershell -Command "(Get-Content %PRODUCT_JSON% -Encoding UTF8) -replace '\"customChineseBrandName\": \"\"', ('\"customChineseBrandName\": \"%BRAND_NAME%\"') | Set-Content %PRODUCT_JSON% -Encoding UTF8"
	powershell -Command "(Get-Content %PRODUCT_JSON% -Encoding UTF8) -replace '\"hideAdvisorEntry\": false', '\"hideAdvisorEntry\": true' | Set-Content %PRODUCT_JSON% -Encoding UTF8"
	powershell -Command "(Get-Content %PRODUCT_JSON% -Encoding UTF8) -replace '\"hideComplaintEntry\": false', '\"hideComplaintEntry\": true' | Set-Content %PRODUCT_JSON% -Encoding UTF8"
	powershell -Command "(Get-Content %PRODUCT_JSON% -Encoding UTF8) -replace '\"hideDisclaimerLinkEntry\": false', '\"hideDisclaimerLinkEntry\": true' | Set-Content %PRODUCT_JSON% -Encoding UTF8"
    powershell -Command "(Get-Content %PRODUCT_JSON% -Encoding UTF8) -replace '\"isPartnerVersion\": false', '\"isPartnerVersion\": true' | Set-Content %PRODUCT_JSON% -Encoding UTF8"
) else (
    echo product.json not found!
    goto :eof
)

REM Replace brand name in files
setlocal enabledelayedexpansion
for %%f in (
    %TEMP_DIR%\%EXTENSION_PATH%\package.json
    %TEMP_DIR%\%EXTENSION_PATH%\product.json
    %TEMP_DIR%\%EXTENSION_PATH%\package.nls.json
    %TEMP_DIR%\%EXTENSION_PATH%\package.nls.zh-cn.json
    %TEMP_DIR%\%EXTENSION_PATH%\src\gpt\promptGPTsList.json
    %TEMP_DIR%\%EXTENSION_PATH%\CHANGELOG.md
    %TEMP_DIR%\%EXTENSION_PATH%\README.md
) do (
    if exist "%%f" (
        powershell -Command "(Get-Content '%%f' -Encoding UTF8) -replace 'CodeArts Agent', '%BRAND_NAME%' | Set-Content '%%f' -Encoding UTF8"
        powershell -Command "(Get-Content '%%f' -Encoding UTF8) -replace 'CodeArts代码智能体', '%BRAND_NAME%' | Set-Content '%%f' -Encoding UTF8"
    ) else (
        echo File not found: %%f
        goto :eof
    )
)

REM Use PowerShell to remove BOM from files
powershell -Command ^
"^
$files = @('%TEMP_DIR%\%EXTENSION_PATH%\package.json', '%TEMP_DIR%\%EXTENSION_PATH%\product.json', '%TEMP_DIR%\%EXTENSION_PATH%\package.nls.json', '%TEMP_DIR%\%EXTENSION_PATH%\package.nls.zh-cn.json', '%TEMP_DIR%\%EXTENSION_PATH%\src\gpt\promptGPTsList.json'); ^
foreach ($file in $files) { ^
    $content = Get-Content -Path $file -Encoding Byte; ^
    if ($content.Length -gt 3 -and $content[0] -eq 0xEF -and $content[1] -eq 0xBB -and $content[2] -eq 0xBF) { ^
        $content = $content[3..($content.Length-1)]; ^
        [System.IO.File]::WriteAllBytes($file, $content); ^
    } ^
} ^
"

REM Copy custom image files
set CUSTOM_IMG_DIR=.\%TEMP_DIR%\%EXTENSION_PATH%\dist\custom-img\
if exist "%CUSTOM_IMG_DIR%" (
    rmdir /s /q %CUSTOM_IMG_DIR%
)
mkdir %CUSTOM_IMG_DIR%

copy .\custom-logo\logo.png %CUSTOM_IMG_DIR%
copy .\custom-logo\posters.png %CUSTOM_IMG_DIR%
copy .\custom-logo\logo_opaque.png .\%TEMP_DIR%\%EXTENSION_PATH%\assets\logo_opaque.png
copy .\custom-logo\activeBarLogo-external.png .\%TEMP_DIR%\%EXTENSION_PATH%\assets\activeBarLogo-external.png
copy .\custom-logo\agentActiveBarLogo.png .\%TEMP_DIR%\%EXTENSION_PATH%\cline\assets\icons\agentActiveBarLogo.png
copy .\custom-logo\dark\connecting.woff .\%TEMP_DIR%\%EXTENSION_PATH%\assets\snap\dark\connecting.woff
copy .\custom-logo\dark\login.woff .\%TEMP_DIR%\%EXTENSION_PATH%\assets\snap\dark\login.woff
copy .\custom-logo\dark\logout.woff .\%TEMP_DIR%\%EXTENSION_PATH%\assets\snap\dark\logout.woff
copy .\custom-logo\light\connecting.woff .\%TEMP_DIR%\%EXTENSION_PATH%\assets\snap\light\connecting.woff
copy .\custom-logo\light\login.woff .\%TEMP_DIR%\%EXTENSION_PATH%\assets\snap\light\login.woff
copy .\custom-logo\light\logout.woff .\%TEMP_DIR%\%EXTENSION_PATH%\assets\snap\light\logout.woff

REM Clean and create temporary directory
if exist "%OUTPUT_DIR%" (rmdir /s /q %OUTPUT_DIR%)
mkdir %OUTPUT_DIR%

for %%F in ("%VSIX_FILE%") do set "FILE_NAME=%%~nxF"

echo extension file name is: %FILE_NAME%

%ZIP_TOOL% a -tzip %OUTPUT_DIR%/%FILE_NAME% %TEMP_DIR%\* -r

REM Clean up temporary directory
rmdir /s /q %TEMP_DIR%

echo Modification complete, new .vsix/carts file located at %OUTPUT_DIR%/%FILE_NAME%
